  Option Autorun On
  Option Explicit
  Option Default None
  Option Base 1
  'Serial#'s & CRC of DS18B20 Temp Sensors.
  Const Ts1a=&H24,Ts1b=&H72,Ts1c=&H4A,Ts1d=&H07,Ts1e=&H00,Ts1f=&H00,Ts1g=&H1B 'Temp Sensor 1
  Const Ts2a=&HC9,Ts2b=&H5D,Ts2c=&H4B,Ts2d=&H07,Ts2e=&H00,Ts2f=&H00,Ts2g=&H60 'Temp Sensor 2
  Const Ts3a=&H46,Ts3b=&HB9,Ts3c=&H4A,Ts3d=&H07,Ts3e=&H00,Ts3f=&H00,Ts3g=&HE4 'Temp Sensor 3
  
  Dim integer Ts1,Ts2,Ts3,Ts4,Ts5,Ts6,Ts7,I,J
  Dim integer Ts (7,3)

  Dim float TmpCur, TmpInp, TmpOut
  Dim float LTemp, HTemp, Value, Status
  
  Dim Float TempNom=25 'Temp for nominal resistance (almost always 25 C)
  Dim Float ThermNom=8000 'Thermistor Resistance at Nominal Temperature (25 degrees C)
  Dim Float ThermSerRes=8200 'Value of the series resistor
  Dim Float StCo(4)=(0.1591512615e-3,3.643285819e-4,-1.094203586e-7,2984.90) 'Steinhart Co-efficients A,B,C & Beta
  
  Dim float ThermRes
  Dim Float ThermVolts
  Dim Float TempBeta
  Dim float TempStHart
  
  '  Dim Float A=0.1591512615e-3, B=3.643285819e-4,C=-1.094203586e-7
  '  Dim Float BCOEFFICIENT=2984.90
  Dim string Esc=Chr$(27)
  Dim String KeyPress
  
  'Pins used - Inputs
  Dim float PinTmp=22     '1-Wire DS18B20 Input Pin
  Dim Float Therm1=4
  
  SetPin Therm1,AIN
  
  Print Esc+"[2J";
  Print Esc+"[?25l";
  RTC Gettime
  
  DATA &H24,&H72,&H4A,&H07,&H00,&H00,&H1B  'Sensor1
  DATA &HC9,&H5D,&H4B,&H07,&H00,&H00,&H60  'Sensor2
  DATA &H46,&HB9,&H4A,&H07,&H00,&H00,&HE4  'Sensor3
  
  Print "FOR - NEXT loop about to start."
  For I = 1 to 3  'sensor # count
    For J = 1 to 7 'id byte count
      Read Ts(J,I) 'read the data in the array
      Print J;I;Ts(J,I)
    Next J
  Next I
  Print "FOR - NEXT loop completed"
  Print "Array Data:-"
  Print Ts(1,1);Ts(2,1);Ts(3,1);Ts(4,1);Ts(5,1);Ts(6,1);Ts(7,1)
  Print Ts(1,2);Ts(2,2);Ts(3,2);Ts(4,2);Ts(5,2);Ts(6,2);Ts(7,2)
  Print Ts(1,3);Ts(2,3);Ts(3,3);Ts(4,3);Ts(5,3);Ts(6,3);Ts(7,3)
  
  pause 5000
  Do
    if inkey$="m" then DoMenu
    KeyPress = INKEY$
    SELECT CASE KeyPress
      CASE "m","M"
        DoMenu
      CASE "1"
        PRINT "Changing target Temperature"
      CASE "2"
        PRINT "Changing Differential"
      CASE "3"
        PRINT "Changing Solar Level"
      CASE "9"
        PRINT "Stop & Shutdown"
        IF menu = 1 THEN END ' only end program if menu is showing
      CASE "0"
        PRINT "Exiting"
        EndMenu
    END SELECT
    
    'ThermVolts = Pin(Therm1)
    'ThermRes=ThermSerRes/(3.3/ThermVolts-1)
    
    '   1/T= A + B*ln(R/Rt) + C*ln(R/Rt)^2 + D*ln(R/Rt)^3
    '   T= 1/(A + B*ln(R/Rt) + C*ln(R/Rt)^2)
    '  TempBeta = ThermRes/ThermNom      '(R/Ro)
    '  TempBeta = Log(TempBeta)                  'ln(R/Ro)
    '  TempBeta = TempBeta / StCo(4)        '1/B * ln(R/Ro)
    '  TempBeta = TempBeta + 1.0 / (TempNom + 273.15)' + (1/To)
    '  TempBeta = 1.0 / TempBeta                 '// Invert
    '  TempBeta = TempBeta - 273.15              '// convert to C
    
    '
    'TempBeta = 1/(1.0/StCo(4)*Log(ThermRes/ThermNom)+1/(TempNom+273.15))-273.15
    'TempStHart = 1/(StCo(1) + StCo(2)*Log(ThermRes) + StCo(3)*(Log(ThermRes))^3)-273.15
    'ThermVolts = ThermVolts*1000
    
    TempTherm Therm1
    GetTemps
    
    Text MM.HRes/40, MM.VRes*1/8, "DS18B20 #1", LM, 2, 1, RGB(Green)
    Text MM.HRes/40, MM.VRes*2/8, "DS18B20 #2", LM, 2, 1, RGB(Cyan)
    Text MM.HRes/40, MM.VRes*3/8, "DS18B20 #3", LM, 2, 1, RGB(Blue)
    Text MM.HRes/40, MM.VRes*4/8, "Therm mVolts", LM, 2, 1, RGB(Red)
    Text MM.HRes/40, MM.VRes*5/8, "Therm Ohms", LM, 2, 1, RGB(White)
    Text MM.HRes/40, MM.VRes*6/8, "Temp Beta", LM, 2, 1, RGB(Magenta)
    Text MM.HRes/40, MM.VRes*7/8, "Temp Steinhart", LM, 2, 1, RGB(Magenta)
    
    Text MM.HRes*39/40, MM.VRes*1/8, Str$(TmpCur,4,1), RM, 2, 1, RGB(Green)
    Text MM.HRes*39/40, MM.VRes*2/8, Str$(TmpInp,4,1), RM, 2, 1, RGB(Cyan)
    Text MM.HRes*39/40, MM.VRes*3/8, Str$(TmpOut,4,1), RM, 2, 1, RGB(Blue)
    Text MM.HRes*39/40, MM.VRes*4/8, Str$(ThermVolts,4,1), RM, 2, 1, RGB(Red)
    Text MM.HRes*39/40, MM.VRes*5/8, Str$(ThermRes,5,1), RM, 2, 1, RGB(Red)
    Text MM.HRes*39/40, MM.VRes*6/8, Str$(TempBeta,3,1), RM, 2, 1, RGB(Magenta)
    Text MM.HRes*39/40, MM.VRes*7/8, Str$(TempStHart,3,1), RM, 2, 1, RGB(Magenta)
    
    
    'Output Stuff to console for debugging purposes
    Print Esc+"[f";
    Print "DS18B20 Number 1 Temp =   ", Str$(TmpCur,4,2)
    Print "DS18B20 Number 2 Temp =   ", Str$(TmpInp,4,2)
    Print "DS18B20 Number 3 Temp =   ", Str$(TmpOut,4,2)
    Print "Thermistor Voltage (mV) = ", Str$(ThermVolts,4,2)
    Print "Thermistor Resistance =   ", Str$(ThermRes,4,2)
    Print "Thermistor Temp Beta      ", Str$(TempBeta,4,2)
    Print "Thermistor Temp Steinhart ", Str$(TempStHart,4,2)
    Print "Time is ", Time$
    Print "Key Pressed is:- ", KeyPress
    Print Ts(1,1);Ts(2,1);Ts(3,1);Ts(4,1);Ts(5,1);Ts(6,1);Ts(7,1)
    
  Loop
  
  '=============================================================================
Sub TempTherm ThermNum As Float
  
  ThermVolts = Pin(ThermNum)
  ThermRes=ThermSerRes/(3.3/ThermVolts-1)
  TempBeta = 1/(1.0/StCo(4)*Log(ThermRes/ThermNom)+1/(TempNom+273.15))-273.15
  TempStHart = 1/(StCo(1) + StCo(2)*Log(ThermRes) + StCo(3)*(Log(ThermRes))^3)-273.15
  ThermVolts = ThermVolts*1000
  
End sub
  
  
  '========================OneWire Temperature Subs=============================
  ' Get the temperatures from multiple probes on a single pin
  ' Device Serial# & CRC is hard coded
  ' Code provided by Matherp
  '=============================================================================
  
Sub GetTemps
  Ts1=Ts(1,1):Ts2=Ts(2,1):Ts3=Ts(3,1):Ts4=Ts(4,1):Ts5=Ts(5,1):Ts6=Ts(6,1):Ts7=Ts(7,1) 'Temp Sensor 1
  
  OneWire Reset PinTmp
  
  'Put 1st sensor serial and crc here (Current Temp)
  'Format is:- &H55,&H28,XX,XX,XX,XX,XX,XX,XX,&H44
  'OneWire Write PinTmp, 1, 10, &H55,&H28,&H24,&H72,&H4A,&H07,&H00,&H00,&H1B,&H44
  'OneWire Write PinTmp, 1, 10, &H55,&H28,Ts1a,Ts1b,Ts1c,Ts1d,Ts1e,Ts1f,Ts1g,&H44
  OneWire Write PinTmp, 1, 10, &H55,&H28,Ts1,Ts2,Ts3,Ts4,Ts5,Ts6,Ts7,&H44
  
  StatusCheck               'check sensor is ready
  '  OneWire Write PinTmp, 1, 10, &H55,&H28,&H24,&H72,&H4A,&H07,&H00,&H00,&H1B,&HBE
  'OneWire Write PinTmp, 1, 10, &H55,&H28,Ts1a,Ts1b,Ts1c,Ts1d,Ts1e,Ts1f,Ts1g,&HBE
  OneWire Write PinTmp, 1, 10, &H55,&H28,Ts1,Ts2,Ts3,Ts4,Ts5,Ts6,Ts7,&HBE
  OneWire Read PinTmp, 2, 2, LTemp, HTemp
  
  TempCalc               'Work out the temp in C
  TmpCur=Value
  
  'Put 2nd sensor serial and crc here (Input Temp)
  'OneWire Write PinTmp, 1, 10, &H55,&H28,&HC9,&H5D,&H4B,&H07,&H00,&H00,&H60,&H44
  OneWire Write PinTmp, 1, 10, &H55,&H28,Ts2a,Ts2b,Ts2c,Ts2d,Ts2e,Ts2f,Ts2g,&H44
  StatusCheck              'check sensor is ready
  'OneWire Write PinTmp, 1, 10, &H55,&H28,&HC9,&H5D,&H4B,&H07,&H00,&H00,&H60,&HBE
  OneWire Write PinTmp, 1, 10, &H55,&H28,Ts2a,Ts2b,Ts2c,Ts2d,Ts2e,Ts2f,Ts2g,&HBE
  OneWire Read PinTmp, 2, 2, LTemp, HTemp
  
  TempCalc               'Work out the temp in C
  TmpInp=Value
  
  'Put 3rd sensor serial and crc here (Output Temp)
  'OneWire Write PinTmp, 1, 10, &H55,&H28,&H46,&HB9,&H4A,&H07,&H00,&H00,&HE4,&H44
  OneWire Write PinTmp, 1, 10, &H55,&H28,Ts3a,Ts3b,Ts3c,Ts3d,Ts3e,Ts3f,Ts3g,&H44
  StatusCheck              'check sensor is ready
  'OneWire Write PinTmp, 1, 10, &H55,&H28,&H46,&HB9,&H4A,&H07,&H00,&H00,&HE4,&HBE
  OneWire Write PinTmp, 1, 10, &H55,&H28,Ts3a,Ts3b,Ts3c,Ts3d,Ts3e,Ts3f,Ts3g,&HBE
  OneWire Read PinTmp, 2, 2, LTemp, HTemp
  
  TempCalc               'Work out the temp in C
  TmpOut=Value
  
End Sub
  '=============================================================================
Sub StatusCheck
  Timer=0 : Status=0
  Do
    If Timer > 1000 Then Error "Sensor Error"
    OneWire Read PinTmp, 4, 1, Status   ' Conversion status
  Loop Until Status = 1
End Sub
  
  '=============================================================================
Sub TempCalc
  Value = ((HTemp And &b111) * 256 + LTemp) / 16
  If HTemp And &b1000 Then Value = -Value  ' adjust if negative
End Sub
  '===========================End of Temp Routines==============================
Sub DoMenu
  SETTICK 5000, EndMenu,4 '  set menu timeout
  'Output Stuff to console for debugging purposes
  Print Esc+"[2J";
  Print Esc+"[f";
  Print "1. Change Target Temperature"
  Print "2. Change Differential"
  Print "3. Change Solar Level"
  Print "9. Stop & Shutdown"
  Print "0. Exit"
  menu = 1 ' a flag so you know when the menu is active
  'pause 5000
  Print Esc+"[2J";
End sub
  
SUB EndMenu
  SETTICK 0,0,4 ' disable the menu timeout
  PRINT Esc+"[2J";
  menu = 0 ' reset menu active flag
END SUB
  
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  ' embedded fonts
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  
  ' Font: Hom_16x24_LE
  ' Includes all ASCII characters
DefineFont #2
  5F201810 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 80010000 80018001
  80018001 80018001 00018001 00010001 00000000 80010000 00008001 00000000
  00000000 00000000 700E0000 700E700E 2004700E 20042004 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 20010000 20012001
  20012001 F80F2001 40024002 F01F4002 40024002 40024002 40024002 00000000
  00000000 00000000 80008000 E8018000 08041802 00040004 E0010002 08001000
  08080800 E00B100C 80008000 80008000 00000000 00000000 00070000 40108008
  40104010 1C078008 0007E000 88007038 04010401 88000401 00007000 00000000
  00000000 00000000 00000000 00000000 C004A003 00040004 00060002 20113009
  4010C010 A0086010 00001807 00000000 00000000 00000000 70000000 E0007000
  8001C000 00000001 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 10000000 20002000 40004000 80004000 80008000 80008000
  80008000 40004000 20004000 10002000 00000000 00000000 00080000 00040004
  00020002 00010002 00010001 00010001 00010001 00020002 00040002 00080004
  00000000 00000000 80000000 80008000 F007980C 6003C001 180C3006 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  80008000 80008000 FC1F8000 80008000 80008000 00008000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 C001C001 00038003 00040006 00000000 00000000 00000000 00000000
  00000000 00000000 FC1F0000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 C001C001 0000C001 00000000 00000000 00000000 08000000 10000800
  20001000 40002000 80004000 00018000 00020001 00040002 00080004 00000008
  00000000 00000000 00000000 3006C001 08081004 08080808 08080808 08080808
  08080808 30061004 0000C001 00000000 00000000 00000000 00000000 800E8001
  80008000 80008000 80008000 80008000 80008000 80008000 0000F80F 00000000
  00000000 00000000 00000000 200CC003 10101010 10001000 40002000 00018000
  00040002 08100008 0000F81F 00000000 00000000 00000000 00000000 3008C007
  10001000 20001000 3000C003 08000800 08000800 300C0810 0000C003 00000000
  00000000 00000000 00000000 A0006000 20012001 20042002 20082004 20102008
  2000F81F 20002000 0000F801 00000000 00000000 00000000 00000000 0008F00F
  00080008 C00B0008 1000300C 08000800 08000800 30181000 0000C007 00000000
  00000000 00000000 00000000 0003F000 00040006 E0090008 080C100A 08080808
  08080808 10060804 0000E001 00000000 00000000 00000000 00000000 1010F01F
  20002010 40002000 40004000 80004000 80008000 00010001 00000001 00000000
  00000000 00000000 00000000 2004C003 10081008 10081008 E0072004 08101008
  08100810 300C1008 0000C003 00000000 00000000 00000000 00000000 3006C001
  0808180C 08080808 28061804 0800C801 10000800 60001000 0000800F 00000000
  00000000 00000000 00000000 00000000 00000000 C001C001 0000C001 00000000
  00000000 C001C001 0000C001 00000000 00000000 00000000 00000000 00000000
  00000000 C001C001 0000C001 00000000 00000000 C001C001 00038003 00040006
  00000000 00000000 00000000 00000000 60001800 00068001 00300018 00060018
  60008001 00001800 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 0000FC3F FC3F0000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00060018 60008001 0C001800 60001800
  00068001 00000018 00000000 00000000 00000000 00000000 00000000 C0070000
  10082008 10001000 20001000 0001C000 00000001 80010000 00008001 00000000
  00000000 00000000 C0030000 1008200C 10101010 90107010 10111011 10111011
  78109010 00100010 300C0008 0000E003 00000000 00000000 00000000 C00F0000
  20024001 20022002 10041004 F80F1004 08080808 04100410 00001E3C 00000000
  00000000 00000000 00000000 F03F0000 04080808 04080408 F00F0808 04080808
  04080408 08080408 0000F03F 00000000 00000000 00000000 00000000 E4010000
  0C0C1406 00100408 00100010 00100010 04080010 18060C0C 0000E001 00000000
  00000000 00000000 00000000 E03F0000 08101810 04100410 04100410 04100410
  04100410 18100810 0000E03F 00000000 00000000 00000000 00000000 F83F0000
  08080808 80080808 800F8008 80088008 04080408 04080408 0000FC3F 00000000
  00000000 00000000 00000000 FC1F0000 04040404 40040404 C0074004 40044004
  00040004 00040004 0000C01F 00000000 00000000 00000000 00000000 C8030000
  1818280C 00200810 00200020 FC200020 08100820 100C0818 0000E003 00000000
  00000000 00000000 00000000 3E3E0000 08080808 08080808 F80F0808 08080808
  08080808 08080808 00003E3E 00000000 00000000 00000000 00000000 F80F0000
  80008000 80008000 80008000 80008000 80008000 80008000 0000F80F 00000000
  00000000 00000000 00000000 FE030000 10001000 10001000 10001000 10101000
  10101010 60082010 00008007 00000000 00000000 00000000 00000000 3C3E0000
  20081008 80084008 000B0009 4008800C 10082008 08081008 00001E3E 00000000
  00000000 00000000 00000000 803F0000 00040004 00040004 00040004 00040004
  04040404 04040404 0000FC3F 00000000 00000000 00000000 00000000 0E380000
  0C180C18 14141414 24122412 C4114411 04100410 04100410 00001E3C 00000000
  00000000 00000000 00000000 7E780000 08140818 08120812 08110811 88108810
  48104810 18102810 0000187E 00000000 00000000 00000000 00000000 E0030000
  0C18180C 02200410 02200220 02200220 04100220 180C0C18 0000E003 00000000
  00000000 00000000 00000000 F01F0000 04040804 04040404 08040404 0004F007
  00040004 00040004 0000C01F 00000000 00000000 00000000 00000000 E0030000
  0C18180C 02200410 02200220 02200220 04100220 180C0C18 8C01E003 0000F006
  00000000 00000000 00000000 E03F0000 08081008 08080808 10080808 4008E00F
  10082008 08081008 00000E3E 00000000 00000000 00000000 00000000 C8030000
  1810280C 00100810 C003000C 08003000 08100800 10140818 0000E013 00000000
  00000000 00000000 00000000 FC1F0000 84108410 84108410 80008000 80008000
  80008000 80008000 0000F007 00000000 00000000 00000000 00000000 7C3E0000
  08100810 08100810 08100810 08100810 08100810 10080810 0000E007 00000000
  00000000 00000000 00000000 3E3E0000 04100410 08080808 10041004 20021004
  20022002 C0014001 00008000 00000000 00000000 00000000 00000000 3E3E0000
  04100410 84108410 44114411 280A4809 280A280A 180C180C 0000180C 00000000
  00000000 00000000 00000000 3E3E0000 10040808 20021004 80004001 20024001
  10042002 08080808 00003E3E 00000000 00000000 00000000 00000000 1E3C0000
  10040808 20021004 40012002 80008000 80008000 80008000 0000F007 00000000
  00000000 00000000 00000000 F81F0000 10100810 40102010 80004000 00020001
  08040802 08100808 0000F81F 00000000 00000000 00000000 E0000000 80008000
  80008000 80008000 80008000 80008000 80008000 80008000 80008000 E0008000
  00000000 00000000 00080000 00040008 00020004 00010002 80000001 40008000
  20004000 10002000 08001000 00000800 00000000 00000000 80030000 80008000
  80008000 80008000 80008000 80008000 80008000 80008000 80008000 80038000
  00000000 00000000 80000000 2002C001 08081004 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  FF7F0000 00000000 80030000 C0018003 6000C000 00002000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 2008C007 10001000 3008D007 10101010 30081010 0000DC07 00000000
  00000000 00000000 00000000 00080038 00080008 0C0AF009 0208040C 02080208
  02080208 0C0A040C 0000F039 00000000 00000000 00000000 00000000 00000000
  00000000 180CE803 08100808 00100010 00100010 180C0C08 0000E003 00000000
  00000000 00000000 00000000 08003800 08000800 2818C807 08201810 08200820
  08200820 28181810 0000CE07 00000000 00000000 00000000 00000000 00000000
  00000000 180CE003 04100808 FC1F0410 00100010 0C0C0008 0000F003 00000000
  00000000 00000000 00000000 8401F800 00010001 0001F80F 00010001 00010001
  00010001 00010001 0000F80F 00000000 00000000 00000000 00000000 00000000
  00000000 2818CE07 08201810 08200820 08200820 28181810 0800C807 10000800
  C00F3000 00000000 00000000 00080038 00080008 100AE009 0808080C 08080808
  08080808 08080808 00003E3E 00000000 00000000 00000000 80000000 80008000
  00000000 80008007 80008000 80008000 80008000 80008000 0000F80F 00000000
  00000000 00000000 20000000 20002000 00000000 1000F00F 10001000 10001000
  10001000 10001000 10001000 20001000 800F6000 00000000 00000000 0004001C
  00040004 20047804 80044004 00070005 40048004 10042004 00003C1C 00000000
  00000000 00000000 00000000 8000800F 80008000 80008000 80008000 80008000
  80008000 80008000 0000FC1F 00000000 00000000 00000000 00000000 00000000
  00000000 C4183877 84108410 84108410 84108410 84108410 0000C67C 00000000
  00000000 00000000 00000000 00000000 00000000 100AE039 0808080C 08080808
  08080808 08080808 00003E3E 00000000 00000000 00000000 00000000 00000000
  00000000 180CE003 04100808 04100410 04100410 180C0808 0000E003 00000000
  00000000 00000000 00000000 00000000 00000000 0C0AF039 0208040C 02080208
  02080208 0C0A040C 0008F009 00080008 003F0008 00000000 00000000 00000000
  00000000 2818CE07 08201810 08200820 08200820 28181810 0800C807 08000800
  7E000800 00000000 00000000 00000000 00000000 C402380E 00020003 00020002
  00020002 00020002 0000F01F 00000000 00000000 00000000 00000000 00000000
  00000000 1804E803 00040804 70008003 08000800 100C0808 0000E00B 00000000
  00000000 00000000 00000000 00040004 00040004 0004F01F 00040004 00040004
  00040004 18020004 0000E001 00000000 00000000 00000000 00000000 00000000
  00000000 08083838 08080808 08080808 08080808 28041808 0000CC03 00000000
  00000000 00000000 00000000 00000000 00000000 08083E3E 10040808 10041004
  20022002 C0014001 00008000 00000000 00000000 00000000 00000000 00000000
  00000000 04101E3C 84100410 48098808 48094809 30065005 00003006 00000000
  00000000 00000000 00000000 00000000 00000000 08083C1E 20021004 80004001
  20024001 08081004 00003C1E 00000000 00000000 00000000 00000000 00000000
  00000000 08103C3C 10080810 20081008 40042004 80024002 00018001 00020001
  803F0002 00000000 00000000 00000000 00000000 0808F80F 20001008 80004000
  00020001 08080804 0000F80F 00000000 00000000 00000000 60000000 80008000
  80008000 80008000 80008000 80000003 80008000 80008000 80008000 60008000
  00000000 00000000 00000000 80000000 80008000 80008000 80008000 80008000
  80008000 80008000 80008000 80008000 00000000 00000000 00030000 80008000
  80008000 80008000 80008000 80006000 80008000 80008000 80008000 00038000
  00000000 00000000 00000000 00000000 00000000 00000000 98190C0F 0000F030
  00000000 00000000 00000000 00000000 00000000
End DefineFont
